import { type NextRequest, NextResponse } from "next/server"
import { query } from "@/lib/db"

export async function GET(request: NextRequest) {
  try {
    const { searchParams } = new URL(request.url)
    const tenantId = searchParams.get("tenant_id")

    if (!tenantId) {
      return NextResponse.json({ error: "Tenant ID is required" }, { status: 400 })
    }

    const result = await query(
      `
      SELECT 
        coa.account_id,
        coa.account_code,
        coa.account_name,
        coa.account_type,
        coa.is_active,
        coa.created_at,
        parent.account_name as parent_account_name
      FROM chart_of_accounts coa
      LEFT JOIN chart_of_accounts parent ON coa.parent_account_id = parent.account_id
      WHERE coa.sys_tenant_id = $1
      ORDER BY coa.account_code
    `,
      [tenantId],
    )

    return NextResponse.json({
      accounts: result.rows,
    })
  } catch (error) {
    console.error("Chart of Accounts API error:", error)
    return NextResponse.json({ error: "Internal server error" }, { status: 500 })
  }
}
