import { type NextRequest, NextResponse } from "next/server"
import { query } from "@/lib/db"

export async function GET(request: NextRequest) {
  try {
    const { searchParams } = new URL(request.url)
    const tenantId = searchParams.get("tenant_id")

    if (!tenantId) {
      return NextResponse.json({ error: "Tenant ID is required" }, { status: 400 })
    }

    const result = await query(
      `
      SELECT 
        ci.invoice_id,
        ci.invoice_number,
        ci.invoice_date,
        ci.due_date,
        ci.status,
        ci.total_amount,
        ci.balance_due,
        ci.created_at,
        c.customer_name,
        dn.dn_number,
        u.first_name || ' ' || u.last_name as created_by_name
      FROM customer_invoice ci
      JOIN customer c ON ci.customer_id = c.customer_id
      LEFT JOIN delivery_note dn ON ci.dn_id = dn.dn_id
      JOIN sys_user u ON ci.created_by = u.user_id
      WHERE ci.sys_tenant_id = $1
      ORDER BY ci.created_at DESC
    `,
      [tenantId],
    )

    return NextResponse.json({
      customerInvoices: result.rows,
    })
  } catch (error) {
    console.error("Customer Invoices API error:", error)
    return NextResponse.json({ error: "Internal server error" }, { status: 500 })
  }
}
