import { type NextRequest, NextResponse } from "next/server"
import { query } from "@/lib/db"

export async function GET(request: NextRequest) {
  try {
    const { searchParams } = new URL(request.url)
    const tenantId = searchParams.get("tenant_id")

    if (!tenantId) {
      return NextResponse.json({ error: "Tenant ID is required" }, { status: 400 })
    }

    const result = await query(
      `
      SELECT 
        dn.dn_id,
        dn.dn_number,
        dn.delivery_date,
        dn.status,
        dn.created_at,
        so.so_number,
        c.customer_name,
        w.warehouse_name,
        u.first_name || ' ' || u.last_name as created_by_name
      FROM delivery_note dn
      JOIN sales_order so ON dn.so_id = so.so_id
      JOIN customer c ON so.customer_id = c.customer_id
      JOIN warehouse w ON dn.warehouse_id = w.warehouse_id
      JOIN sys_user u ON dn.created_by = u.user_id
      WHERE dn.sys_tenant_id = $1
      ORDER BY dn.created_at DESC
    `,
      [tenantId],
    )

    return NextResponse.json({
      deliveryNotes: result.rows,
    })
  } catch (error) {
    console.error("Delivery Notes API error:", error)
    return NextResponse.json({ error: "Internal server error" }, { status: 500 })
  }
}
