import { type NextRequest, NextResponse } from "next/server"
import { query } from "@/lib/db"

export async function GET(request: NextRequest) {
  try {
    const { searchParams } = new URL(request.url)
    const tenantId = searchParams.get("tenant_id")

    if (!tenantId) {
      return NextResponse.json({ error: "Tenant ID is required" }, { status: 400 })
    }

    const result = await query(
      `
      SELECT 
        gr.grn_id,
        gr.grn_number,
        gr.receipt_date,
        gr.status,
        gr.created_at,
        po.po_number,
        s.supplier_name,
        w.warehouse_name,
        u.first_name || ' ' || u.last_name as created_by_name
      FROM goods_receipt gr
      JOIN purchase_order po ON gr.po_id = po.po_id
      JOIN supplier s ON po.supplier_id = s.supplier_id
      JOIN warehouse w ON gr.warehouse_id = w.warehouse_id
      JOIN sys_user u ON gr.created_by = u.user_id
      WHERE gr.sys_tenant_id = $1
      ORDER BY gr.created_at DESC
    `,
      [tenantId],
    )

    return NextResponse.json({
      goodsReceipts: result.rows,
    })
  } catch (error) {
    console.error("Goods Receipt API error:", error)
    return NextResponse.json({ error: "Internal server error" }, { status: 500 })
  }
}
