import { type NextRequest, NextResponse } from "next/server"
import { query } from "@/lib/db"

export async function GET(request: NextRequest) {
  try {
    const { searchParams } = new URL(request.url)
    const tenantId = searchParams.get("tenant_id")

    if (!tenantId) {
      return NextResponse.json({ error: "Tenant ID is required" }, { status: 400 })
    }

    const result = await query(
      `
      SELECT 
        je.entry_id,
        je.entry_number,
        je.entry_date,
        je.reference_type,
        je.reference_id,
        je.description,
        je.total_debit,
        je.total_credit,
        je.status,
        je.created_at,
        u.first_name || ' ' || u.last_name as created_by_name
      FROM journal_entry je
      JOIN sys_user u ON je.created_by = u.user_id
      WHERE je.sys_tenant_id = $1
      ORDER BY je.created_at DESC
    `,
      [tenantId],
    )

    return NextResponse.json({
      journalEntries: result.rows,
    })
  } catch (error) {
    console.error("Journal Entries API error:", error)
    return NextResponse.json({ error: "Internal server error" }, { status: 500 })
  }
}
