import { type NextRequest, NextResponse } from "next/server"
import { query } from "@/lib/db"

export async function GET(request: NextRequest) {
  try {
    const { searchParams } = new URL(request.url)
    const tenantId = searchParams.get("tenant_id")

    if (!tenantId) {
      return NextResponse.json({ error: "Tenant ID is required" }, { status: 400 })
    }

    const result = await query(
      `
      SELECT 
        p.product_id,
        p.product_code,
        p.product_name,
        p.base_unit,
        p.is_active,
        p.created_at,
        pc.category_name,
        COUNT(pv.variant_id) as variant_count
      FROM product p
      LEFT JOIN product_category pc ON p.category_id = pc.category_id
      LEFT JOIN product_variant pv ON p.product_id = pv.product_id
      WHERE p.sys_tenant_id = $1
      GROUP BY p.product_id, p.product_code, p.product_name, p.base_unit, p.is_active, p.created_at, pc.category_name
      ORDER BY p.created_at DESC
    `,
      [tenantId],
    )

    return NextResponse.json({
      products: result.rows,
    })
  } catch (error) {
    console.error("Products API error:", error)
    return NextResponse.json({ error: "Internal server error" }, { status: 500 })
  }
}
