import { type NextRequest, NextResponse } from "next/server"
import { query } from "@/lib/db"

export async function GET(request: NextRequest) {
  try {
    const { searchParams } = new URL(request.url)
    const tenantId = searchParams.get("tenant_id")

    if (!tenantId) {
      return NextResponse.json({ error: "Tenant ID is required" }, { status: 400 })
    }

    const result = await query(
      `
      SELECT 
        sa.adjustment_id,
        sa.adjustment_number,
        sa.adjustment_date,
        sa.adjustment_type,
        sa.status,
        sa.reason,
        sa.total_items,
        sa.created_at,
        w.warehouse_name,
        u.first_name || ' ' || u.last_name as created_by_name
      FROM stock_adjustment sa
      JOIN warehouse w ON sa.warehouse_id = w.warehouse_id
      JOIN sys_user u ON sa.created_by = u.user_id
      WHERE sa.sys_tenant_id = $1
      ORDER BY sa.created_at DESC
    `,
      [tenantId],
    )

    return NextResponse.json({
      adjustments: result.rows,
    })
  } catch (error) {
    console.error("Stock Adjustments API error:", error)
    return NextResponse.json({ error: "Internal server error" }, { status: 500 })
  }
}
