import { type NextRequest, NextResponse } from "next/server"
import { query } from "@/lib/db"

export async function GET(request: NextRequest) {
  try {
    const { searchParams } = new URL(request.url)
    const tenantId = searchParams.get("tenant_id")

    if (!tenantId) {
      return NextResponse.json({ error: "Tenant ID is required" }, { status: 400 })
    }

    const result = await query(
      `
      SELECT 
        si.invoice_id,
        si.invoice_number,
        si.supplier_invoice_number,
        si.invoice_date,
        si.due_date,
        si.status,
        si.total_amount,
        si.balance_due,
        si.created_at,
        s.supplier_name,
        gr.grn_number,
        u.first_name || ' ' || u.last_name as created_by_name
      FROM supplier_invoice si
      JOIN supplier s ON si.supplier_id = s.supplier_id
      LEFT JOIN goods_receipt gr ON si.grn_id = gr.grn_id
      JOIN sys_user u ON si.created_by = u.user_id
      WHERE si.sys_tenant_id = $1
      ORDER BY si.created_at DESC
    `,
      [tenantId],
    )

    return NextResponse.json({
      supplierInvoices: result.rows,
    })
  } catch (error) {
    console.error("Supplier Invoices API error:", error)
    return NextResponse.json({ error: "Internal server error" }, { status: 500 })
  }
}
