import { type NextRequest, NextResponse } from "next/server"
import { query } from "@/lib/db"

export async function GET(request: NextRequest) {
  try {
    const { searchParams } = new URL(request.url)
    const tenantId = searchParams.get("tenant_id")

    if (!tenantId) {
      return NextResponse.json({ error: "Tenant ID is required" }, { status: 400 })
    }

    const result = await query(
      `
      SELECT 
        supplier_id,
        supplier_code,
        supplier_name,
        contact_person,
        email,
        phone,
        city,
        payment_terms,
        is_active,
        created_at
      FROM supplier
      WHERE sys_tenant_id = $1
      ORDER BY created_at DESC
    `,
      [tenantId],
    )

    return NextResponse.json({
      suppliers: result.rows,
    })
  } catch (error) {
    console.error("Suppliers API error:", error)
    return NextResponse.json({ error: "Internal server error" }, { status: 500 })
  }
}
