import { type NextRequest, NextResponse } from "next/server"
import { query } from "@/lib/db"

export async function GET(request: NextRequest) {
  try {
    const { searchParams } = new URL(request.url)
    const tenantId = searchParams.get("tenant_id")

    if (!tenantId) {
      return NextResponse.json({ error: "Tenant ID is required" }, { status: 400 })
    }

    const result = await query(
      `
      SELECT 
        warehouse_id,
        warehouse_code,
        warehouse_name,
        address,
        city,
        state,
        country,
        is_active,
        created_at
      FROM warehouse
      WHERE sys_tenant_id = $1
      ORDER BY warehouse_name
    `,
      [tenantId],
    )

    return NextResponse.json({
      warehouses: result.rows,
    })
  } catch (error) {
    console.error("Warehouses API error:", error)
    return NextResponse.json({ error: "Internal server error" }, { status: 500 })
  }
}
