import { requireAuth } from "@/lib/auth"
import { DashboardLayout } from "@/components/dashboard-layout"
import { ChartOfAccountsTable } from "@/components/chart-of-accounts-table"
import { Button } from "@/components/ui/button"
import { Plus } from "lucide-react"

export default async function ChartOfAccountsPage() {
  const user = await requireAuth()

  return (
    <DashboardLayout user={user}>
      <div className="space-y-6">
        <div className="flex items-center justify-between">
          <div>
            <h1 className="text-3xl font-bold text-foreground">Chart of Accounts</h1>
            <p className="text-muted-foreground">Manage your accounting structure and account classifications</p>
          </div>
          <Button>
            <Plus className="mr-2 h-4 w-4" />
            Add Account
          </Button>
        </div>

        <ChartOfAccountsTable tenantId={user.sys_tenant_id} />
      </div>
    </DashboardLayout>
  )
}
