import { requireAuth } from "@/lib/auth"
import { DashboardLayout } from "@/components/dashboard-layout"
import { CustomerInvoicesTable } from "@/components/customer-invoices-table"
import { Button } from "@/components/ui/button"
import { Plus } from "lucide-react"

export default async function CustomerInvoicesPage() {
  const user = await requireAuth()

  return (
    <DashboardLayout user={user}>
      <div className="space-y-6">
        <div className="flex items-center justify-between">
          <div>
            <h1 className="text-3xl font-bold text-foreground">Customer Invoices</h1>
            <p className="text-muted-foreground">Manage customer invoices and track payment collections</p>
          </div>
          <Button>
            <Plus className="mr-2 h-4 w-4" />
            Create Invoice
          </Button>
        </div>

        <CustomerInvoicesTable tenantId={user.sys_tenant_id} />
      </div>
    </DashboardLayout>
  )
}
