import { requireAuth } from "@/lib/auth"
import { DashboardLayout } from "@/components/dashboard-layout"
import { CustomersTable } from "@/components/customers-table"
import { Button } from "@/components/ui/button"
import { Plus } from "lucide-react"

export default async function CustomersPage() {
  const user = await requireAuth()

  return (
    <DashboardLayout user={user}>
      <div className="space-y-6">
        <div className="flex items-center justify-between">
          <div>
            <h1 className="text-3xl font-bold text-foreground">Customers</h1>
            <p className="text-muted-foreground">Manage your customer relationships and contacts</p>
          </div>
          <Button>
            <Plus className="mr-2 h-4 w-4" />
            Add Customer
          </Button>
        </div>

        <CustomersTable tenantId={user.sys_tenant_id} />
      </div>
    </DashboardLayout>
  )
}
