import { requireAuth } from "@/lib/auth"
import { DashboardLayout } from "@/components/dashboard-layout"
import { DeliveryNotesTable } from "@/components/delivery-notes-table"
import { Button } from "@/components/ui/button"
import { Plus } from "lucide-react"

export default async function DeliveryNotesPage() {
  const user = await requireAuth()

  return (
    <DashboardLayout user={user}>
      <div className="space-y-6">
        <div className="flex items-center justify-between">
          <div>
            <h1 className="text-3xl font-bold text-foreground">Delivery Notes</h1>
            <p className="text-muted-foreground">Track and manage product deliveries to customers</p>
          </div>
          <Button>
            <Plus className="mr-2 h-4 w-4" />
            Create Delivery Note
          </Button>
        </div>

        <DeliveryNotesTable tenantId={user.sys_tenant_id} />
      </div>
    </DashboardLayout>
  )
}
