import { requireAuth } from "@/lib/auth"
import { DashboardLayout } from "@/components/dashboard-layout"
import { GoodsReceiptTable } from "@/components/goods-receipt-table"
import { Button } from "@/components/ui/button"
import { Plus } from "lucide-react"

export default async function GoodsReceiptPage() {
  const user = await requireAuth()

  return (
    <DashboardLayout user={user}>
      <div className="space-y-6">
        <div className="flex items-center justify-between">
          <div>
            <h1 className="text-3xl font-bold text-foreground">Goods Receipt Notes</h1>
            <p className="text-muted-foreground">Record and manage incoming inventory from suppliers</p>
          </div>
          <Button>
            <Plus className="mr-2 h-4 w-4" />
            Create GRN
          </Button>
        </div>

        <GoodsReceiptTable tenantId={user.sys_tenant_id} />
      </div>
    </DashboardLayout>
  )
}
