import { requireAuth } from "@/lib/auth"
import { DashboardLayout } from "@/components/dashboard-layout"
import { InventoryTable } from "@/components/inventory-table"
import { InventoryStats } from "@/components/inventory-stats"
import { Button } from "@/components/ui/button"
import { Plus, RotateCcw, ArrowUpDown } from "lucide-react"

export default async function InventoryPage() {
  const user = await requireAuth()

  return (
    <DashboardLayout user={user}>
      <div className="space-y-6">
        <div className="flex items-center justify-between">
          <div>
            <h1 className="text-3xl font-bold text-foreground">Inventory Management</h1>
            <p className="text-muted-foreground">
              Monitor stock levels, manage transfers, and track inventory movements
            </p>
          </div>
          <div className="flex items-center gap-2">
            <Button variant="outline">
              <ArrowUpDown className="mr-2 h-4 w-4" />
              Stock Transfer
            </Button>
            <Button variant="outline">
              <RotateCcw className="mr-2 h-4 w-4" />
              Stock Adjustment
            </Button>
            <Button>
              <Plus className="mr-2 h-4 w-4" />
              Stocktaking
            </Button>
          </div>
        </div>

        <InventoryStats tenantId={user.sys_tenant_id} />
        <InventoryTable tenantId={user.sys_tenant_id} />
      </div>
    </DashboardLayout>
  )
}
