import { requireAuth } from "@/lib/auth"
import { DashboardLayout } from "@/components/dashboard-layout"
import { JournalEntriesTable } from "@/components/journal-entries-table"
import { Button } from "@/components/ui/button"
import { Plus } from "lucide-react"

export default async function JournalEntriesPage() {
  const user = await requireAuth()

  return (
    <DashboardLayout user={user}>
      <div className="space-y-6">
        <div className="flex items-center justify-between">
          <div>
            <h1 className="text-3xl font-bold text-foreground">Journal Entries</h1>
            <p className="text-muted-foreground">
              View and manage accounting journal entries and financial transactions
            </p>
          </div>
          <Button>
            <Plus className="mr-2 h-4 w-4" />
            Manual Entry
          </Button>
        </div>

        <JournalEntriesTable tenantId={user.sys_tenant_id} />
      </div>
    </DashboardLayout>
  )
}
