import { requireAuth } from "@/lib/auth"
import { DashboardLayout } from "@/components/dashboard-layout"
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card"
import { BarChart3, Package, Users, ShoppingCart, Truck, FileText } from "lucide-react"

export default async function DashboardPage() {
  const user = await requireAuth()

  const stats = [
    { title: "Total Products", value: "1,234", icon: Package, change: "+12%" },
    { title: "Active Customers", value: "856", icon: Users, change: "+8%" },
    { title: "Pending Orders", value: "42", icon: ShoppingCart, change: "-3%" },
    { title: "Shipments Today", value: "18", icon: Truck, change: "+15%" },
  ]

  return (
    <DashboardLayout user={user}>
      <div className="space-y-6">
        <div>
          <h1 className="text-3xl font-bold text-foreground">Dashboard</h1>
          <p className="text-muted-foreground">
            Welcome back, {user.first_name}! Here's what's happening with your business.
          </p>
        </div>

        <div className="grid gap-4 md:grid-cols-2 lg:grid-cols-4">
          {stats.map((stat) => (
            <Card key={stat.title}>
              <CardHeader className="flex flex-row items-center justify-between space-y-0 pb-2">
                <CardTitle className="text-sm font-medium text-muted-foreground">{stat.title}</CardTitle>
                <stat.icon className="h-4 w-4 text-muted-foreground" />
              </CardHeader>
              <CardContent>
                <div className="text-2xl font-bold text-foreground">{stat.value}</div>
                <p className="text-xs text-muted-foreground">
                  <span className={stat.change.startsWith("+") ? "text-green-600" : "text-red-600"}>{stat.change}</span>{" "}
                  from last month
                </p>
              </CardContent>
            </Card>
          ))}
        </div>

        <div className="grid gap-6 md:grid-cols-2">
          <Card>
            <CardHeader>
              <CardTitle className="flex items-center gap-2">
                <BarChart3 className="h-5 w-5" />
                Recent Activity
              </CardTitle>
              <CardDescription>Latest transactions and updates</CardDescription>
            </CardHeader>
            <CardContent>
              <div className="space-y-4">
                <div className="flex items-center gap-3">
                  <div className="w-2 h-2 bg-green-500 rounded-full"></div>
                  <div className="flex-1">
                    <p className="text-sm font-medium">New customer registered</p>
                    <p className="text-xs text-muted-foreground">2 minutes ago</p>
                  </div>
                </div>
                <div className="flex items-center gap-3">
                  <div className="w-2 h-2 bg-blue-500 rounded-full"></div>
                  <div className="flex-1">
                    <p className="text-sm font-medium">Purchase order PO-2024-001 created</p>
                    <p className="text-xs text-muted-foreground">15 minutes ago</p>
                  </div>
                </div>
                <div className="flex items-center gap-3">
                  <div className="w-2 h-2 bg-orange-500 rounded-full"></div>
                  <div className="flex-1">
                    <p className="text-sm font-medium">Inventory low for Product ABC-123</p>
                    <p className="text-xs text-muted-foreground">1 hour ago</p>
                  </div>
                </div>
              </div>
            </CardContent>
          </Card>

          <Card>
            <CardHeader>
              <CardTitle className="flex items-center gap-2">
                <FileText className="h-5 w-5" />
                Quick Actions
              </CardTitle>
              <CardDescription>Common tasks and shortcuts</CardDescription>
            </CardHeader>
            <CardContent>
              <div className="grid gap-2">
                <button className="flex items-center gap-2 p-2 text-left hover:bg-muted rounded-md transition-colors">
                  <Package className="h-4 w-4" />
                  <span className="text-sm">Add New Product</span>
                </button>
                <button className="flex items-center gap-2 p-2 text-left hover:bg-muted rounded-md transition-colors">
                  <Users className="h-4 w-4" />
                  <span className="text-sm">Create Customer</span>
                </button>
                <button className="flex items-center gap-2 p-2 text-left hover:bg-muted rounded-md transition-colors">
                  <ShoppingCart className="h-4 w-4" />
                  <span className="text-sm">New Purchase Order</span>
                </button>
                <button className="flex items-center gap-2 p-2 text-left hover:bg-muted rounded-md transition-colors">
                  <FileText className="h-4 w-4" />
                  <span className="text-sm">Generate Report</span>
                </button>
              </div>
            </CardContent>
          </Card>
        </div>
      </div>
    </DashboardLayout>
  )
}
