import { requireAuth } from "@/lib/auth"
import { DashboardLayout } from "@/components/dashboard-layout"
import { PurchaseOrdersTable } from "@/components/purchase-orders-table"
import { Button } from "@/components/ui/button"
import { Plus } from "lucide-react"

export default async function PurchaseOrdersPage() {
  const user = await requireAuth()

  return (
    <DashboardLayout user={user}>
      <div className="space-y-6">
        <div className="flex items-center justify-between">
          <div>
            <h1 className="text-3xl font-bold text-foreground">Purchase Orders</h1>
            <p className="text-muted-foreground">
              Manage procurement workflow from purchase orders to supplier payments
            </p>
          </div>
          <Button>
            <Plus className="mr-2 h-4 w-4" />
            Create Purchase Order
          </Button>
        </div>

        <PurchaseOrdersTable tenantId={user.sys_tenant_id} />
      </div>
    </DashboardLayout>
  )
}
