import { requireAuth } from "@/lib/auth"
import { DashboardLayout } from "@/components/dashboard-layout"
import { SalesOrdersTable } from "@/components/sales-orders-table"
import { Button } from "@/components/ui/button"
import { Plus } from "lucide-react"

export default async function SalesOrdersPage() {
  const user = await requireAuth()

  return (
    <DashboardLayout user={user}>
      <div className="space-y-6">
        <div className="flex items-center justify-between">
          <div>
            <h1 className="text-3xl font-bold text-foreground">Sales Orders</h1>
            <p className="text-muted-foreground">Manage sales workflow from customer orders to payment collection</p>
          </div>
          <Button>
            <Plus className="mr-2 h-4 w-4" />
            Create Sales Order
          </Button>
        </div>

        <SalesOrdersTable tenantId={user.sys_tenant_id} />
      </div>
    </DashboardLayout>
  )
}
