import { requireAuth } from "@/lib/auth"
import { DashboardLayout } from "@/components/dashboard-layout"
import { StockAdjustmentsTable } from "@/components/stock-adjustments-table"
import { Button } from "@/components/ui/button"
import { Plus } from "lucide-react"

export default async function StockAdjustmentsPage() {
  const user = await requireAuth()

  return (
    <DashboardLayout user={user}>
      <div className="space-y-6">
        <div className="flex items-center justify-between">
          <div>
            <h1 className="text-3xl font-bold text-foreground">Stock Adjustments</h1>
            <p className="text-muted-foreground">Record inventory adjustments for damaged, lost, or found items</p>
          </div>
          <Button>
            <Plus className="mr-2 h-4 w-4" />
            New Adjustment
          </Button>
        </div>

        <StockAdjustmentsTable tenantId={user.sys_tenant_id} />
      </div>
    </DashboardLayout>
  )
}
