import { requireAuth } from "@/lib/auth"
import { DashboardLayout } from "@/components/dashboard-layout"
import { SuppliersTable } from "@/components/suppliers-table"
import { Button } from "@/components/ui/button"
import { Plus } from "lucide-react"

export default async function SuppliersPage() {
  const user = await requireAuth()

  return (
    <DashboardLayout user={user}>
      <div className="space-y-6">
        <div className="flex items-center justify-between">
          <div>
            <h1 className="text-3xl font-bold text-foreground">Suppliers</h1>
            <p className="text-muted-foreground">Manage your supplier relationships and vendor contacts</p>
          </div>
          <Button>
            <Plus className="mr-2 h-4 w-4" />
            Add Supplier
          </Button>
        </div>

        <SuppliersTable tenantId={user.sys_tenant_id} />
      </div>
    </DashboardLayout>
  )
}
