"use client"

import type React from "react"

import { useEffect, useState } from "react"
import { useRouter } from "next/navigation"
import type { User } from "@/lib/auth"
import { Loader2 } from "lucide-react"

interface AuthGuardProps {
  children: React.ReactNode
  requiredPermission?: string
}

export function AuthGuard({ children, requiredPermission }: AuthGuardProps) {
  const [user, setUser] = useState<User | null>(null)
  const [isLoading, setIsLoading] = useState(true)
  const router = useRouter()

  useEffect(() => {
    const checkAuth = async () => {
      try {
        const response = await fetch("/api/auth/me")
        if (response.ok) {
          const userData = await response.json()
          setUser(userData.user)

          if (
            requiredPermission &&
            !userData.user.permissions.includes(requiredPermission) &&
            !userData.user.roles.includes("Administrator")
          ) {
            router.push("/unauthorized")
            return
          }
        } else {
          router.push("/login")
          return
        }
      } catch (error) {
        console.error("Auth check failed:", error)
        router.push("/login")
        return
      } finally {
        setIsLoading(false)
      }
    }

    checkAuth()
  }, [router, requiredPermission])

  if (isLoading) {
    return (
      <div className="min-h-screen flex items-center justify-center">
        <Loader2 className="h-8 w-8 animate-spin text-primary" />
      </div>
    )
  }

  if (!user) {
    return null
  }

  return <>{children}</>
}
