"use client"

import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card"
import { Button } from "@/components/ui/button"
import { Badge } from "@/components/ui/badge"
import { Download, Eye, BarChart3, DollarSign, Package, TrendingUp } from "lucide-react"

interface ReportsGridProps {
  tenantId: string
}

const reportCategories = [
  {
    title: "Financial Reports",
    icon: DollarSign,
    color: "text-green-600",
    reports: [
      { name: "Profit & Loss Statement", description: "Income and expenses overview", type: "financial" },
      { name: "Balance Sheet", description: "Assets, liabilities, and equity", type: "financial" },
      { name: "Cash Flow Statement", description: "Cash inflows and outflows", type: "financial" },
      { name: "Trial Balance", description: "Account balances verification", type: "financial" },
      { name: "Accounts Receivable Aging", description: "Outstanding customer payments", type: "financial" },
      { name: "Accounts Payable Aging", description: "Outstanding supplier payments", type: "financial" },
    ],
  },
  {
    title: "Sales Reports",
    icon: TrendingUp,
    color: "text-blue-600",
    reports: [
      { name: "Sales Summary", description: "Total sales by period", type: "sales" },
      { name: "Customer Sales Analysis", description: "Sales performance by customer", type: "sales" },
      { name: "Product Sales Analysis", description: "Best and worst performing products", type: "sales" },
      { name: "Sales Order Status", description: "Order fulfillment tracking", type: "sales" },
      { name: "Sales Commission Report", description: "Commission calculations", type: "sales" },
    ],
  },
  {
    title: "Inventory Reports",
    icon: Package,
    color: "text-purple-600",
    reports: [
      { name: "Stock Levels Report", description: "Current inventory quantities", type: "inventory" },
      { name: "Low Stock Alert", description: "Items below reorder level", type: "inventory" },
      { name: "Inventory Valuation", description: "Total inventory value", type: "inventory" },
      { name: "Stock Movement Report", description: "Inventory transactions history", type: "inventory" },
      { name: "Dead Stock Analysis", description: "Slow-moving inventory items", type: "inventory" },
      { name: "ABC Analysis", description: "Inventory classification by value", type: "inventory" },
    ],
  },
  {
    title: "Procurement Reports",
    icon: BarChart3,
    color: "text-orange-600",
    reports: [
      { name: "Purchase Summary", description: "Total purchases by period", type: "procurement" },
      { name: "Supplier Performance", description: "Supplier delivery and quality metrics", type: "procurement" },
      { name: "Purchase Order Status", description: "PO tracking and fulfillment", type: "procurement" },
      { name: "Cost Analysis", description: "Purchase cost trends", type: "procurement" },
    ],
  },
]

export function ReportsGrid({ tenantId }: ReportsGridProps) {
  const handleGenerateReport = (reportName: string, reportType: string) => {
    console.log(`Generating ${reportName} report for tenant ${tenantId}`)
    // Here you would implement the actual report generation logic
  }

  const handleViewReport = (reportName: string) => {
    console.log(`Viewing ${reportName} report`)
    // Here you would implement the report viewing logic
  }

  return (
    <div className="space-y-8">
      {reportCategories.map((category) => (
        <Card key={category.title}>
          <CardHeader>
            <CardTitle className="flex items-center gap-2">
              <category.icon className={`h-5 w-5 ${category.color}`} />
              {category.title}
            </CardTitle>
            <CardDescription>Generate and view {category.title.toLowerCase()} for your business</CardDescription>
          </CardHeader>
          <CardContent>
            <div className="grid gap-4 md:grid-cols-2 lg:grid-cols-3">
              {category.reports.map((report) => (
                <Card key={report.name} className="border-muted">
                  <CardHeader className="pb-3">
                    <div className="flex items-start justify-between">
                      <div className="space-y-1">
                        <CardTitle className="text-sm font-medium">{report.name}</CardTitle>
                        <CardDescription className="text-xs">{report.description}</CardDescription>
                      </div>
                      <Badge variant="secondary" className="text-xs">
                        {report.type}
                      </Badge>
                    </div>
                  </CardHeader>
                  <CardContent className="pt-0">
                    <div className="flex items-center gap-2">
                      <Button
                        size="sm"
                        variant="outline"
                        onClick={() => handleViewReport(report.name)}
                        className="flex-1"
                      >
                        <Eye className="mr-1 h-3 w-3" />
                        View
                      </Button>
                      <Button
                        size="sm"
                        onClick={() => handleGenerateReport(report.name, report.type)}
                        className="flex-1"
                      >
                        <Download className="mr-1 h-3 w-3" />
                        Generate
                      </Button>
                    </div>
                  </CardContent>
                </Card>
              ))}
            </div>
          </CardContent>
        </Card>
      ))}
    </div>
  )
}
