import { neon } from "@neondatabase/serverless"

if (!process.env.DATABASE_URL) {
  throw new Error("DATABASE_URL environment variable is required")
}

const sql = neon(process.env.DATABASE_URL)

export { sql }

export interface User {
  user_id: string
  sys_tenant_id: string
  username: string
  email: string
  full_name: string
  is_active: boolean
}

export interface Product {
  product_id: string
  sys_tenant_id: string
  product_code: string
  product_name: string
  description: string
  unit_of_measure: string
  unit_price: number
  is_active: boolean
}

export interface Customer {
  customer_id: string
  sys_tenant_id: string
  customer_code: string
  customer_name: string
  email: string
  phone: string
  address: string
  is_active: boolean
}

export interface Supplier {
  supplier_id: string
  sys_tenant_id: string
  supplier_code: string
  supplier_name: string
  email: string
  phone: string
  address: string
  is_active: boolean
}
