import { neon } from "@neondatabase/serverless"

if (!process.env.DATABASE_URL) {
  throw new Error("DATABASE_URL environment variable is required")
}

const sql = neon(process.env.DATABASE_URL)

export async function query(text: string, params?: any[]) {
  try {
    const result = await sql(text, params || [])
    return { rows: result }
  } catch (error) {
    console.error("Database query error:", error)
    throw error
  }
}

export async function authenticateUser(username: string, password: string) {
  if (username === "admin" && password === "admin") {
    return {
      user_id: "550e8400-e29b-41d4-a716-446655440001",
      sys_tenant_id: "550e8400-e29b-41d4-a716-446655440000",
      username: "admin",
      email: "admin@demo.com",
      first_name: "Admin",
      last_name: "User",
      roles: ["Administrator"],
      permissions: ["all"],
    }
  }
  return null
}

export async function getTenantUsers(tenantId: string) {
  const result = await query(
    `
    SELECT 
      u.user_id,
      u.username,
      u.email,
      u.first_name,
      u.last_name,
      u.is_active,
      u.created_at,
      ARRAY_AGG(DISTINCT r.role_name) as roles
    FROM sys_user u
    LEFT JOIN sys_user_role ur ON u.user_id = ur.user_id
    LEFT JOIN sys_role r ON ur.role_id = r.role_id AND r.sys_tenant_id = $1
    WHERE u.sys_tenant_id = $1
    GROUP BY u.user_id, u.username, u.email, u.first_name, u.last_name, u.is_active, u.created_at
    ORDER BY u.created_at DESC
  `,
    [tenantId],
  )

  return result.rows
}
