-- ERP System Database Schema
-- Multi-tenant architecture with comprehensive business modules

-- Core system tables
CREATE TABLE IF NOT EXISTS sys_tenants (
    tenant_id UUID PRIMARY KEY DEFAULT gen_random_uuid(),
    tenant_name VARCHAR(100) NOT NULL,
    tenant_code VARCHAR(20) UNIQUE NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE IF NOT EXISTS sys_users (
    user_id UUID PRIMARY KEY DEFAULT gen_random_uuid(),
    sys_tenant_id UUID NOT NULL REFERENCES sys_tenants(tenant_id),
    username VARCHAR(50) UNIQUE NOT NULL,
    email VARCHAR(100) UNIQUE NOT NULL,
    password_hash VARCHAR(255) NOT NULL,
    full_name VARCHAR(100) NOT NULL,
    is_active BOOLEAN DEFAULT true,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE IF NOT EXISTS sys_roles (
    role_id UUID PRIMARY KEY DEFAULT gen_random_uuid(),
    sys_tenant_id UUID NOT NULL REFERENCES sys_tenants(tenant_id),
    role_name VARCHAR(50) NOT NULL,
    description TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE IF NOT EXISTS sys_user_roles (
    user_id UUID REFERENCES sys_users(user_id),
    role_id UUID REFERENCES sys_roles(role_id),
    PRIMARY KEY (user_id, role_id)
);

-- Master data tables
CREATE TABLE IF NOT EXISTS md_products (
    product_id UUID PRIMARY KEY DEFAULT gen_random_uuid(),
    sys_tenant_id UUID NOT NULL REFERENCES sys_tenants(tenant_id),
    product_code VARCHAR(50) NOT NULL,
    product_name VARCHAR(200) NOT NULL,
    description TEXT,
    unit_of_measure VARCHAR(20) DEFAULT 'EA',
    unit_price DECIMAL(15,2) DEFAULT 0,
    is_active BOOLEAN DEFAULT true,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    UNIQUE(sys_tenant_id, product_code)
);

CREATE TABLE IF NOT EXISTS md_customers (
    customer_id UUID PRIMARY KEY DEFAULT gen_random_uuid(),
    sys_tenant_id UUID NOT NULL REFERENCES sys_tenants(tenant_id),
    customer_code VARCHAR(50) NOT NULL,
    customer_name VARCHAR(200) NOT NULL,
    email VARCHAR(100),
    phone VARCHAR(20),
    address TEXT,
    is_active BOOLEAN DEFAULT true,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    UNIQUE(sys_tenant_id, customer_code)
);

CREATE TABLE IF NOT EXISTS md_suppliers (
    supplier_id UUID PRIMARY KEY DEFAULT gen_random_uuid(),
    sys_tenant_id UUID NOT NULL REFERENCES sys_tenants(tenant_id),
    supplier_code VARCHAR(50) NOT NULL,
    supplier_name VARCHAR(200) NOT NULL,
    email VARCHAR(100),
    phone VARCHAR(20),
    address TEXT,
    is_active BOOLEAN DEFAULT true,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    UNIQUE(sys_tenant_id, supplier_code)
);

-- Inventory tables
CREATE TABLE IF NOT EXISTS inv_stock_balances (
    stock_balance_id UUID PRIMARY KEY DEFAULT gen_random_uuid(),
    sys_tenant_id UUID NOT NULL REFERENCES sys_tenants(tenant_id),
    product_id UUID NOT NULL REFERENCES md_products(product_id),
    location_code VARCHAR(20) DEFAULT 'MAIN',
    quantity_on_hand DECIMAL(15,3) DEFAULT 0,
    last_updated TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    UNIQUE(sys_tenant_id, product_id, location_code)
);
