-- Seed initial data for demo
INSERT INTO sys_tenants (tenant_id, tenant_name, tenant_code) 
VALUES ('550e8400-e29b-41d4-a716-446655440000', 'Demo Company', 'DEMO')
ON CONFLICT (tenant_code) DO NOTHING;

-- Create demo user (password: demo123)
INSERT INTO sys_users (user_id, sys_tenant_id, username, email, password_hash, full_name)
VALUES (
    '550e8400-e29b-41d4-a716-446655440001',
    '550e8400-e29b-41d4-a716-446655440000',
    'demo',
    'demo@company.com',
    '$2b$10$rQZ8kHp0rJ0YvM5qJ5qJ5uJ5qJ5qJ5qJ5qJ5qJ5qJ5qJ5qJ5qJ5qJ',
    'Demo User'
) ON CONFLICT (username) DO NOTHING;

-- Create admin role
INSERT INTO sys_roles (role_id, sys_tenant_id, role_name, description)
VALUES (
    '550e8400-e29b-41d4-a716-446655440002',
    '550e8400-e29b-41d4-a716-446655440000',
    'Admin',
    'System Administrator'
) ON CONFLICT DO NOTHING;

-- Assign role to user
INSERT INTO sys_user_roles (user_id, role_id)
VALUES (
    '550e8400-e29b-41d4-a716-446655440001',
    '550e8400-e29b-41d4-a716-446655440002'
) ON CONFLICT DO NOTHING;

-- Sample products
INSERT INTO md_products (sys_tenant_id, product_code, product_name, description, unit_price)
VALUES 
    ('550e8400-e29b-41d4-a716-446655440000', 'LAPTOP001', 'Business Laptop', 'High-performance laptop for business use', 1299.99),
    ('550e8400-e29b-41d4-a716-446655440000', 'MOUSE001', 'Wireless Mouse', 'Ergonomic wireless mouse', 29.99),
    ('550e8400-e29b-41d4-a716-446655440000', 'KEYBOARD001', 'Mechanical Keyboard', 'RGB mechanical keyboard', 149.99)
ON CONFLICT (sys_tenant_id, product_code) DO NOTHING;

-- Sample customers
INSERT INTO md_customers (sys_tenant_id, customer_code, customer_name, email, phone)
VALUES 
    ('550e8400-e29b-41d4-a716-446655440000', 'CUST001', 'Acme Corporation', 'orders@acme.com', '+1-555-0123'),
    ('550e8400-e29b-41d4-a716-446655440000', 'CUST002', 'Tech Solutions Inc', 'purchasing@techsol.com', '+1-555-0456')
ON CONFLICT (sys_tenant_id, customer_code) DO NOTHING;

-- Sample suppliers
INSERT INTO md_suppliers (sys_tenant_id, supplier_code, supplier_name, email, phone)
VALUES 
    ('550e8400-e29b-41d4-a716-446655440000', 'SUPP001', 'Global Tech Supply', 'sales@globaltech.com', '+1-555-0789'),
    ('550e8400-e29b-41d4-a716-446655440000', 'SUPP002', 'Office Equipment Co', 'orders@officeequip.com', '+1-555-0321')
ON CONFLICT (sys_tenant_id, supplier_code) DO NOTHING;
