-- Create Chart of Accounts table
CREATE TABLE chart_of_accounts (
    id SERIAL PRIMARY KEY,
    sys_tenant_id INTEGER NOT NULL,
    account_code VARCHAR(20) NOT NULL,
    account_name VARCHAR(255) NOT NULL,
    account_type VARCHAR(50) NOT NULL, -- Asset, Liability, Equity, Revenue, Expense
    parent_account_id INTEGER REFERENCES chart_of_accounts(id),
    is_active BOOLEAN DEFAULT true,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    UNIQUE(sys_tenant_id, account_code)
);

-- Create Journal Entries table
CREATE TABLE journal_entries (
    id SERIAL PRIMARY KEY,
    sys_tenant_id INTEGER NOT NULL,
    entry_number VARCHAR(50) NOT NULL,
    entry_date DATE NOT NULL,
    description TEXT,
    reference_type VARCHAR(50), -- PO, SO, GRN, INV, etc.
    reference_id INTEGER,
    total_debit DECIMAL(15,2) DEFAULT 0,
    total_credit DECIMAL(15,2) DEFAULT 0,
    status VARCHAR(20) DEFAULT 'draft', -- draft, posted, reversed
    created_by INTEGER,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    posted_at TIMESTAMP,
    UNIQUE(sys_tenant_id, entry_number)
);

-- Create Journal Entry Lines table
CREATE TABLE journal_entry_lines (
    id SERIAL PRIMARY KEY,
    sys_tenant_id INTEGER NOT NULL,
    journal_entry_id INTEGER NOT NULL REFERENCES journal_entries(id),
    account_id INTEGER NOT NULL REFERENCES chart_of_accounts(id),
    description TEXT,
    debit_amount DECIMAL(15,2) DEFAULT 0,
    credit_amount DECIMAL(15,2) DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Insert default Chart of Accounts
INSERT INTO chart_of_accounts (sys_tenant_id, account_code, account_name, account_type) VALUES
(1, '1000', 'Assets', 'Asset'),
(1, '1100', 'Current Assets', 'Asset'),
(1, '1110', 'Cash and Cash Equivalents', 'Asset'),
(1, '1120', 'Accounts Receivable', 'Asset'),
(1, '1130', 'Inventory', 'Asset'),
(1, '1200', 'Non-Current Assets', 'Asset'),
(1, '1210', 'Property, Plant & Equipment', 'Asset'),
(1, '2000', 'Liabilities', 'Liability'),
(1, '2100', 'Current Liabilities', 'Liability'),
(1, '2110', 'Accounts Payable', 'Liability'),
(1, '2120', 'Accrued Expenses', 'Liability'),
(1, '3000', 'Equity', 'Equity'),
(1, '3100', 'Share Capital', 'Equity'),
(1, '3200', 'Retained Earnings', 'Equity'),
(1, '4000', 'Revenue', 'Revenue'),
(1, '4100', 'Sales Revenue', 'Revenue'),
(1, '5000', 'Cost of Goods Sold', 'Expense'),
(1, '5100', 'Direct Materials', 'Expense'),
(1, '6000', 'Operating Expenses', 'Expense'),
(1, '6100', 'Administrative Expenses', 'Expense');

-- Create indexes for performance
CREATE INDEX idx_journal_entries_tenant ON journal_entries(sys_tenant_id);
CREATE INDEX idx_journal_entries_date ON journal_entries(entry_date);
CREATE INDEX idx_journal_entry_lines_tenant ON journal_entry_lines(sys_tenant_id);
CREATE INDEX idx_journal_entry_lines_account ON journal_entry_lines(account_id);
CREATE INDEX idx_chart_of_accounts_tenant ON chart_of_accounts(sys_tenant_id);
