# Simple Product Scraper Extension

A Chrome extension that extracts product information from e-commerce websites and outputs it as JSON.

## Features

- Extracts product data (title, price, images, description, etc.)
- Outputs data in clean JSON format
- Simple one-click interface
- Copy to clipboard functionality

## Installation

1. Download or clone this repository
2. Open Chrome and navigate to `chrome://extensions`
3. Enable "Developer mode" in the top right corner
4. Click "Load unpacked" and select the extension directory

## Usage

1. Navigate to a product page on any e-commerce website
2. Click the extension icon in the toolbar
3. Click the "Scrape Product Data" button
4. View the extracted JSON data
5. Use the "Copy JSON" button to copy the data to your clipboard

## Output Format

The extension will output product data in the following JSON format:

```json
{
  "url": "https://example.com/product",
  "timestamp": "2023-01-01T00:00:00.000Z",
  "title": "Product Title",
  "price": "$99.99",
  "currency": "$",
  "images": [
    "https://example.com/image1.jpg",
    "https://example.com/image2.jpg"
  ],
  "description": "Product description text",
  "availability": "In Stock",
  "rating": "4.5 stars",
  "reviews": "123 reviews"
}
```

## How It Works

The extension uses content scripts to analyze the current webpage and identify product information using common CSS selectors. It looks for elements with classes or attributes that typically contain product data.

## Supported Sites

This extension should work on most e-commerce sites, including:
- Amazon
- eBay
- Shopify stores
- WooCommerce sites
- And many others

## Limitations

- Some sites may have anti-scraping measures that prevent data extraction
- Data accuracy depends on how consistently the website structures its product information
- Single-page applications may require additional handling

## Customization

To improve detection for specific sites, you can modify the selectors in `content.js`:
- `titleSelectors`: CSS selectors for product titles
- `priceSelectors`: CSS selectors for product prices
- `imageSelectors`: CSS selectors for product images
- `descSelectors`: CSS selectors for product descriptions
- `availabilitySelectors`: CSS selectors for availability information
- `ratingSelectors`: CSS selectors for product ratings
- `reviewSelectors`: CSS selectors for review counts