# Simple Product Scraper Chrome Extension

## Overview
This is a simplified Chrome extension that extracts product information from e-commerce websites and outputs the data as JSON. It's similar to the "Cross Border Product Collector" and "BigSeller Product Scraper" extensions but with a focus on clean JSON output only.

## Features
- Extracts common product data (title, price, images, description, etc.)
- Clean JSON output format
- One-click scraping from the browser toolbar
- Copy to clipboard functionality

## Files Included
1. `manifest.json` - Extension configuration and permissions
2. `content.js` - Content script that extracts product data from web pages
3. `popup.html` - User interface for the extension popup
4. `popup.js` - JavaScript for the popup interface
5. `README.md` - Documentation
6. `package.json` - Package information
7. `test-product.html` - Sample product page for testing
8. `product-scraper-extension.zip` - Packaged extension for installation

## Installation Instructions
1. Open Chrome and navigate to `chrome://extensions`
2. Enable "Developer mode" in the top right corner
3. Click "Load unpacked" and select the extension directory, or
4. Drag and drop the `product-scraper-extension.zip` file onto the extensions page

## Usage Instructions
1. Navigate to a product page on any e-commerce website
2. Click the extension icon in the toolbar (puzzle piece icon)
3. Click the "Scrape Product Data" button
4. View the extracted JSON data in the popup
5. Use the "Copy JSON" button to copy the data to your clipboard

## JSON Output Format
```json
{
  "url": "Current page URL",
  "timestamp": "ISO timestamp of when data was scraped",
  "title": "Product title",
  "price": "Product price with currency symbol",
  "currency": "Currency symbol (if detected)",
  "images": ["Array of image URLs"],
  "description": "Product description",
  "availability": "Stock status",
  "rating": "Product rating",
  "reviews": "Number of reviews"
}
```

## How It Works
The extension uses CSS selectors to identify and extract product information from web pages. It tries multiple common selectors for each data point to maximize compatibility across different e-commerce sites.

## Customization
To improve detection for specific sites, you can modify the selectors in `content.js`:
- `titleSelectors`: For product titles
- `priceSelectors`: For product prices
- `imageSelectors`: For product images
- `descSelectors`: For product descriptions
- `availabilitySelectors`: For stock status
- `ratingSelectors`: For product ratings
- `reviewSelectors`: For review counts

## Limitations
- May not work on sites with anti-scraping measures
- Data accuracy depends on site structure
- Single-page applications may require additional handling

## Testing
A sample product page (`test-product.html`) is included for testing the extension functionality.