// Popup script for the extension
document.addEventListener('DOMContentLoaded', function() {
  const scrapeBtn = document.getElementById('scrapeBtn');
  const resultDiv = document.getElementById('result');
  const copyBtn = document.getElementById('copyBtn');
  const statusDiv = document.getElementById('status');
  
  // When the scrape button is clicked
  scrapeBtn.addEventListener('click', async function() {
    // Update status
    statusDiv.textContent = 'Scraping...';
    scrapeBtn.disabled = true;
    
    try {
      // Get the active tab
      const [tab] = await chrome.tabs.query({active: true, currentWindow: true});
      
      // Send a message to the content script to scrape product data
      const response = await chrome.tabs.sendMessage(tab.id, {action: "scrapeProduct"});
      
      if (response && response.productData) {
        // Format the data as JSON
        const jsonData = JSON.stringify(response.productData, null, 2);
        
        // Display the result
        resultDiv.innerHTML = `<pre>${jsonData}</pre>`;
        resultDiv.style.display = 'block';
        copyBtn.style.display = 'block';
        statusDiv.textContent = 'Scraping complete!';
      } else {
        statusDiv.textContent = 'No product data found';
        resultDiv.style.display = 'none';
        copyBtn.style.display = 'none';
      }
    } catch (error) {
      console.error('Error scraping product data:', error);
      statusDiv.textContent = 'Error: ' + error.message;
      resultDiv.style.display = 'none';
      copyBtn.style.display = 'none';
    } finally {
      scrapeBtn.disabled = false;
    }
  });
  
  // When the copy button is clicked
  copyBtn.addEventListener('click', function() {
    const jsonData = resultDiv.textContent;
    navigator.clipboard.writeText(jsonData)
      .then(() => {
        // Show feedback
        const originalText = copyBtn.textContent;
        copyBtn.textContent = 'Copied!';
        setTimeout(() => {
          copyBtn.textContent = originalText;
        }, 2000);
      })
      .catch(err => {
        console.error('Failed to copy: ', err);
      });
  });
});