# Shopee Bulk Review Scraper V5

## 1. Tujuan Utama

Ekstensi ini dirancang untuk melakukan scraping (pengambilan data) ulasan produk secara massal dari daftar URL produk Shopee Indonesia. Fokus utamanya adalah mengambil ulasan yang disertai media (gambar/video), menanganinya dalam jumlah besar secara andal, dan menyajikannya dalam satu file CSV yang komprehensif.

Versi ini merupakan peningkatan besar yang mencakup dashboard monitoring, penyimpanan data yang kuat, dan proses yang lebih cerdas, termasuk penanganan CAPTCHA.

---

## 2. Fitur Utama

- **Scraping dari Banyak URL**: Kemampuan untuk memproses daftar panjang URL produk Shopee dalam satu sesi.
- **Fokus pada Ulasan Media**: Secara otomatis mengklik filter "Dengan Media" pada halaman produk untuk memastikan data yang diambil adalah yang paling relevan secara visual.
- **Penanganan CAPTCHA Cerdas**: Jika Shopee menampilkan halaman CAPTCHA, proses akan **otomatis dijeda**, memberi tahu pengguna, dan akan **otomatis berlanjut** setelah CAPTCHA diselesaikan. Jika tidak ada tindakan, proses akan timeout dan lanjut ke URL berikutnya.
- **Penyimpanan Andal (IndexedDB)**: Menggunakan database internal browser (IndexedDB) yang mampu menampung puluhan ribu data ulasan tanpa risiko crash atau kehilangan data.
- **Deduplikasi Otomatis**: Ulasan duplikat secara otomatis diabaikan saat dimasukkan ke database, memastikan data hasil akhir bersih.
- **Dashboard Monitoring Live**: Menyediakan antarmuka di tab terpisah yang tidak akan tertutup, memungkinkan pengguna memantau progres scraping secara real-time.
- **Pelacakan Status Detail**: Setiap URL akan dilacak statusnya secara individual (Menunggu, Diproses, Sukses, Gagal, atau Perlu Tindakan), lengkap dengan ringkasan hasilnya.
- **Unduhan Otomatis**: Setelah proses selesai, file CSV akan langsung tersimpan ke folder "Downloads" browser tanpa perlu dialog konfirmasi "Save As".
- **Format CSV Lengkap**: File CSV yang dihasilkan mengandung 21 kolom data yang kaya, termasuk `itemid`, `shopid`, `model_id`, `model_name`, `like_count`, dan lainnya.
- **Proses Cerdas & Cepat**: Mengganti mekanisme delay statis dengan sistem berbasis event yang menunggu elemen halaman muncul, membuat proses scraping lebih cepat.

---

## 3. Panduan Pengguna

1.  **Buka Popup Ekstensi**: Klik ikon ekstensi di toolbar browser Anda.
2.  **Masukkan Daftar URL**: Salin dan tempel semua URL produk Shopee ke dalam area teks.
3.  **Mulai Proses**: Klik tombol **"Start"**.
4.  **Buka Dashboard (Sangat Direkomendasikan)**: Segera setelah memulai, klik tombol **"Open Monitoring Dashboard"**. Ini akan membuka antarmuka pemantauan di tab baru.
5.  **Pantau Progres**: Amati "Live Log" di dashboard. Anda akan melihat status setiap URL berubah.
6.  **Jika Muncul CAPTCHA**: 
    - Status di dashboard akan berubah menjadi **"🏃‍♀️ Perlu Tindakan: Selesaikan CAPTCHA..."**.
    - Pindah ke tab kerja tempat scraping berjalan (biasanya tab paling kanan), lalu selesaikan CAPTCHA.
    - Setelah berhasil, proses akan **otomatis berlanjut**.
    - Jika Anda tidak melakukan apa-apa selama 5 menit, ekstensi akan melewati URL tersebut dan lanjut ke URL berikutnya.
7.  **Tunggu Hingga Selesai**: Biarkan proses berjalan. Setelah semua URL diproses, file CSV akan otomatis terunduh.
8.  **Salin Ringkasan (Opsional)**: Setelah selesai, sebuah area teks berisi ringkasan lengkap sesi akan muncul di dashboard, siap untuk disalin.

---

## 4. Penjelasan Antarmuka (UI) & Pengalaman Pengguna (UX)

- **Tombol Start**: Memulai keseluruhan proses scraping.
- **Tombol Stop & Save**: Menghentikan proses secara paksa kapan saja (bahkan saat dijeda karena CAPTCHA) dan langsung menghasilkan file CSV dari data yang sudah berhasil terkumpul.
- **Tombol Open Monitoring Dashboard**: Membuka antarmuka ini di tab baru agar tidak mudah tertutup.
- **Area Status**: Menampilkan status proses secara keseluruhan.
- **Area Live Log**: Menampilkan daftar semua URL beserta status dan ringkasan hasilnya secara real-time dengan ikon:
    - ⏳ **pending**: Menunggu giliran untuk diproses.
    - 🏃 **processing**: Sedang aktif di-scrape.
    - ✅ **success**: Berhasil di-scrape, lengkap dengan jumlah data yang ditemukan.
    - ❌ **failed**: Gagal di-scrape, lengkap dengan pesan error.
    - 🏃‍♀️ **captcha**: Proses dijeda, perlu intervensi pengguna untuk menyelesaikan CAPTCHA.
- **Area Final Summary**: Muncul setelah proses selesai, berisi rekapitulasi dari Live Log dalam format teks yang mudah disalin.

---

## 5. Alur Kerja & Logika Teknis

- **Arsitektur**: Ekstensi ini dibangun menggunakan **Manifest V3**.
- **Service Worker (`background.js`)**: Bertindak sebagai otak dan koordinator utama. Ia mengelola antrian URL, menangani penyimpanan data ke IndexedDB, memicu unduhan, dan mengelola jeda proses.
- **Content Script (`content.js`)**: Disuntikkan ke halaman Shopee. Bertugas untuk interaksi halaman, mendengarkan data, dan melaporkan status (termasuk saat mendeteksi kemungkinan CAPTCHA).
- **Penyimpanan Data**: Menggunakan **IndexedDB** untuk persistensi data skala besar.
- **Jeda & Lanjutan (Alarms)**: Menggunakan `chrome.alarms` API untuk membuat timer timeout 5 menit saat proses dijeda karena CAPTCHA, memastikan antrian tidak tersangkut selamanya.

---

## 6. Penanganan Error & CAPTCHA

Sistem ini dirancang untuk berjalan mandiri (unattended) dengan penanganan skenario berikut:

- **CAPTCHA**: Proses akan dijeda selama 5 menit. Jika CAPTCHA diselesaikan dalam rentang waktu tersebut, proses akan otomatis lanjut. Jika tidak, URL tersebut akan ditandai gagal dan proses lanjut ke URL berikutnya.
- **Halaman Error/Tidak Ditemukan**: Jika sebuah URL menghasilkan halaman error (bukan halaman produk), skrip akan timeout saat mencari elemen ulasan, lalu akan ditangani oleh logika CAPTCHA (dijeda 5 menit, lalu gagal dan lanjut).
- **Berhenti Manual**: Pengguna dapat kapan saja menekan "Stop & Save" untuk mengakhiri sesi dan mengamankan data yang sudah terkumpul.

---

## 7. Catatan untuk Pengembang & Troubleshooting

Bagian ini berisi catatan teknis yang dapat membantu dalam pengembangan atau saat mengatasi masalah di masa depan.

### Pentingnya Izin (Permissions) di `manifest.json`

Ekstensi Manifest V3 memerlukan izin eksplisit untuk hampir setiap `chrome.*` API yang digunakan. Lupa menambahkan satu izin dapat menyebabkan error yang menghentikan seluruh ekstensi.

**Contoh Kasus Nyata:**
Selama pengembangan fitur "Timeout Otomatis untuk CAPTCHA", kami menggunakan `chrome.alarms` API. Awalnya, kami lupa menambahkan izin `"alarms"` ke dalam `manifest.json`.

Hal ini menyebabkan error berikut saat ekstensi dimuat:
`Uncaught TypeError: Cannot read properties of undefined (reading 'onAlarm')`

**Analisis Error:**
- Error ini terjadi karena skrip (`background.js`) mencoba menjalankan `chrome.alarms.onAlarm`.
- Namun, karena izin `"alarms"` tidak ada di manifest, objek `chrome.alarms` itu sendiri menjadi `undefined`.
- Mencoba mengakses properti `.onAlarm` dari sesuatu yang `undefined` menyebabkan `TypeError`.
- Error ini cukup fatal untuk menghentikan registrasi Service Worker, yang mengakibatkan ekstensi tidak dapat berjalan sama sekali (ditandai dengan error `Service worker registration failed. Status code: 15`).

**Pelajaran**: Jika Anda menambahkan fungsionalitas baru yang menggunakan `chrome.*` API, selalu periksa dokumentasi resmi untuk memastikan apakah API tersebut memerlukan izin khusus, dan segera tambahkan izin tersebut ke `manifest.json`.
