(function() {
    const reviewUrl = '/api/v2/item/get_ratings';
    const productUrl = '/api/v4/pdp/get_pc';

    const originalFetch = window.fetch;
    window.fetch = async function(...args) {
        const url = args[0];
        const response = await originalFetch.apply(this, args);

        if (typeof url === 'string') {
            if (url.includes(reviewUrl)) {
                response.clone().text().then(body => {
                    window.dispatchEvent(new CustomEvent('ReviewDataIntercepted', { detail: body }));
                });
            } else if (url.includes(productUrl)) {
                response.clone().text().then(body => {
                    window.dispatchEvent(new CustomEvent('ProductDataIntercepted', { detail: body }));
                });
            }
        }
        return response;
    };

    const originalOpen = XMLHttpRequest.prototype.open;
    XMLHttpRequest.prototype.open = function(method, url) {
        if (typeof url === 'string') {
            if (url.includes(reviewUrl)) {
                this.addEventListener('load', function() {
                    if (this.readyState === 4) {
                        window.dispatchEvent(new CustomEvent('ReviewDataIntercepted', { detail: this.responseText }));
                    }
                });
            } else if (url.includes(productUrl)) {
                this.addEventListener('load', function() {
                    if (this.readyState === 4) {
                        window.dispatchEvent(new CustomEvent('ProductDataIntercepted', { detail: this.responseText }));
                    }
                });
            }
        }
        originalOpen.apply(this, arguments);
    };
})();