# Penjelasan Ekstensi: Shopee Shop Product Bulk Scraper

## Tujuan Utama
Ekstensi ini berfungsi untuk mengumpulkan (scrape) data produk dari **beberapa halaman** di sebuah toko Shopee Indonesia dan menyimpannya sebagai satu file CSV. Data yang diambil meliputi Nama Produk, Nama Toko, Harga, Jumlah Terjual, Link Produk, dan URL Gambar.

## Poin Paling Penting: Proses Scraping Bersifat Semi-Manual
Proses scraping dengan ekstensi ini **tidak sepenuhnya otomatis**. Ekstensi tidak akan berpindah dari satu halaman ke halaman berikutnya tanpa perintah dari Anda.

Anda **wajib menekan tombol `Next Page ➡️`** di dalam popup ekstensi untuk setiap halaman baru yang ingin Anda kumpulkan datanya. Ini adalah sebuah fitur desain yang disengaja untuk:
1.  **Memberi Anda Kontrol Penuh**: Anda bisa menentukan sendiri berapa banyak halaman yang ingin di-scrape.
2.  **Menghindari Deteksi**: Dengan adanya jeda dan tindakan manual, aktivitas scraping lebih menyerupai perilaku pengguna normal, mengurangi risiko diblokir oleh Shopee.

---

## Cara Penggunaan (Langkah demi Langkah)

1.  **Buka Halaman Toko di Shopee**: Buka situs `shopee.co.id` dan navigasi ke halaman toko yang ingin Anda scrape produknya (contoh: `https://shopee.co.id/namatoko`). Pastikan Anda berada di tab "Produk".

2.  **Buka Ekstensi di Halaman Pertama**: Setelah halaman produk pertama toko muncul, klik ikon ekstensi "Shopee Shop Product Bulk Scraper" di toolbar browser Anda untuk membuka popup.

3.  **Scrape Halaman Pertama**: Saat popup terbuka, ekstensi akan secara otomatis meng-scrape semua produk di halaman yang sedang aktif. Anda akan melihat angka pada "Products Scraped" bertambah.

4.  **Pindah ke Halaman Berikutnya (Langkah Manual)**:
    *   Untuk mengambil data dari halaman kedua, **klik tombol `Next Page ➡️`** di dalam popup ekstensi.
    *   Ekstensi kemudian akan mensimulasikan klik pada tombol panah "selanjutnya" di halaman web Shopee.
    *   Tunggu halaman memuat produk-produk baru. Setelah selesai, ekstensi akan otomatis meng-scrape data dari halaman kedua ini, dan jumlah "Products Scraped" akan bertambah lagi.

5.  **Ulangi Proses**: Ulangi langkah ke-4 untuk setiap halaman berikutnya (halaman 3, 4, 5, dst.) yang datanya ingin Anda kumpulkan. Setiap kali Anda menekan `Next Page ➡️`, Anda menambahkan produk dari halaman baru ke dalam koleksi.

6.  **Selesaikan dan Unduh**: Jika Anda sudah selesai mengumpulkan data dari semua halaman yang diinginkan, klik tombol **`Finish & Download 🏁`**.

7.  **Simpan File**: Sebuah dialog "Simpan Sebagai" akan muncul, memungkinkan Anda untuk menyimpan file `shopee_shop_bulk_products.csv` yang berisi semua data yang telah terkumpul. Setelah unduhan dimulai, data yang tersimpan di ekstensi akan otomatis dibersihkan.

---

## Penjelasan Fungsi Tombol di Popup

*   **`Next Page ➡️`**: Tombol utama selama proses scraping. Fungsinya untuk memicu navigasi ke halaman selanjutnya dan meng-scrape data di sana. **Harus ditekan secara manual untuk setiap halaman.**
*   **`Finish & Download 🏁`**: Mengakhiri sesi scraping, mengubah semua data yang terkumpul menjadi file CSV, dan mengunduhnya.
*   **`Clear Stored Data 🗑️`**: Menghapus semua data yang sudah di-scrape tanpa mengunduh. Berguna jika Anda ingin membatalkan sesi saat ini dan memulai dari awal.

---
## Fitur Tambahan: Scraping Produk Habis

Ekstensi ini juga akan secara otomatis mendeteksi dan meng-scrape produk yang "habis terjual" (sold out).

- Setelah Anda mencapai halaman terakhir dari produk yang tersedia, menekan tombol `Next Page ➡️` lagi akan membuat ekstensi mencari tombol "Lihat Lainnya" untuk produk habis.
- Jika ditemukan, ekstensi akan mengkliknya dan secara otomatis meng-scrape produk-produk yang muncul.
- Anda bisa terus menekan `Next Page ➡️` hingga semua produk habis ter-scrape.
