function injectScript(filePath) {
    const s = document.createElement('script');
    s.src = chrome.runtime.getURL(filePath);
    s.onload = function() { this.remove(); };
    (document.head || document.documentElement).appendChild(s);
}
injectScript('interceptor.js');

window.addEventListener('ShopProductListIntercepted', (event) => {
    try {
        const data = JSON.parse(event.detail);

        if (data.error && data.error !== 0) {
            console.error('Shop Bulk Scraper: API returned an error.', data);
            return;
        }

        let items = null;
        if (data && data.items) {
            items = data.items;
        } else if (data && data.centralize_item_card && data.centralize_item_card.item_cards) {
            items = data.centralize_item_card.item_cards;
        } else if (data && data.data && data.data.items) {
            items = data.data.items;
        } else if (data && data.data && data.data.centralize_item_card && data.data.centralize_item_card.item_cards) {
            items = data.data.centralize_item_card.item_cards;
        }

        if (!items || items.length === 0) {
            console.log('Shop Bulk Scraper: Intercepted a response with no items. Skipping.');
            return;
        }

        const shopName = document.title.split('-')[0].trim();

        const products = items.map(item => {
            if (!item || !item.item_card_displayed_asset) return null;

            const name = String(item.item_card_displayed_asset.name || '');
            const price = (item.item_card_display_price && item.item_card_display_price.price / 100000) || 0;
            const hostname = window.location.hostname;
            const imgDomainPrefix = hostname.includes('.my') ? 'down-my' : 'down-id';
            const imageUrl = `https://${imgDomainPrefix}.img.susercontent.com/file/${item.item_card_displayed_asset.image}`;
            
            let sold = 0;
            const soldText = item.item_card_display_sold_count?.historical_sold_count_text || '';
            if (soldText) {
                if (soldText.toLowerCase().includes('rb')) {
                    const num = parseFloat(soldText.replace(/,/g, '.').match(/[\d,.]+/)[0].replace(/,/g, '.'));
                    sold = num * 1000;
                } else {
                    const match = soldText.match(/\d+/);
                    if (match) sold = parseInt(match[0], 10);
                }
            }
            if (sold === 0) {
                 const monthlySoldText = item.item_card_display_sold_count?.monthly_sold_count_text || '';
                 const match = monthlySoldText.match(/\d+/);
                 if (match) sold = parseInt(match[0], 10);
            }
             if (sold === 0) {
                sold = (item.item_card_display_sold_count && item.item_card_display_sold_count.historical_sold_count) || item.historical_sold || item.sold || 0;
            }

            const rating = item.item_rating?.rating_star.toFixed(2) || 0;
            const rating_count = item.item_rating?.rating_count[0] || 0;
            const liked_count = item.liked_count || 0;
            const shop_location = item.shop_data?.shop_location || '';
            const brand = item.global_brand?.display_name || 'No Brand';
            const variations = (item.tier_variations || []).map(v => {
                return `${v.name}: ${v.options.join(', ')}`;
            }).join('; ');

            const slug = name.toLowerCase()
                .replaceAll('/', ' ')
                .replaceAll(/[^a-z0-9 -]/g, '')
                .trim()
                .replaceAll(/\s+/g, '-');
            const productLink = `https://${window.location.hostname}/${slug}-i.${item.shopid}.${item.itemid}`;

            return {
                itemid: item.itemid,
                shopid: item.shopid,
                model_id: item.item_card_display_price?.model_id || 0,
                name: name,
                price: price,
                sold: sold,
                rating: rating,
                rating_count: rating_count,
                liked_count: liked_count,
                shop_location: shop_location,
                brand: brand,
                variations: variations,
                product_link: productLink,
                image_url: imageUrl,
                shop_name: shopName
            };
        }).filter(p => p !== null);

        if (products.length > 0) {
            chrome.runtime.sendMessage({ action: 'store_products', payload: products });
        }

    } catch (e) {
        console.error('Shop Bulk Scraper: Failed to process intercepted data.', e);
    }
});