(function() {
    const processResponse = (responseText) => {
        const event = new CustomEvent('ShopProductListIntercepted', {
            detail: responseText
        });
        window.dispatchEvent(event);
    };

    // --- Patch XMLHttpRequest ---
    const origOpen = XMLHttpRequest.prototype.open;
    XMLHttpRequest.prototype.open = function(method, url) {
        if (typeof url === 'string' && (url.includes('/api/v4/shop/rcmd_items') || url.includes('/api/v4/shop/search_items'))) {
            this.addEventListener('load', function() {
                if (this.readyState === 4) {
                    processResponse(this.responseText);
                }
            });
        }
        origOpen.apply(this, arguments);
    };

    // --- Patch fetch ---
    const origFetch = window.fetch;
    window.fetch = async function(...args) {
        const response = await origFetch.apply(this, args);
        const url = args[0];

        if (typeof url === 'string' && (url.includes('/api/v4/shop/rcmd_items') || url.includes('/api/v4/shop/search_items'))) {
            response.clone().text().then(body => {
                processResponse(body);
            });
        }
        return response;
    };
})();